package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.EstudioDocOS3Dao;
import com.ejie.ab04b.model.EstudioDocOS3;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0444s00ServiceImpl generated by UDA, 14-Feb-2017 10:29:39.
 * 
 * @author UDA
 */

@Service(value = "estudioDocOS3ServiceImpl")
public class EstudioDocOS3ServiceImpl implements EstudioDocOS3Service {

	@Autowired()
	private EstudioDocOS3Dao ab0444s00Dao;

	/**
	 * Inserts a single row in the Ab0444s00 table.
	 * 
	 *  ab0444s00
	 *            Ab0444s00
	 *  Ab0444s00
	 *
	 * @param ab0444s00 the ab 0444 s 00
	 * @return the estudio doc OS 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EstudioDocOS3 add(EstudioDocOS3 ab0444s00) {
		return this.ab0444s00Dao.add(ab0444s00);
	}

	/**
	 * Updates a single row in the Ab0444s00 table.
	 * 
	 *  ab0444s00
	 *            Ab0444s00
	 *  Ab0444s00
	 *
	 * @param ab0444s00 the ab 0444 s 00
	 * @return the estudio doc OS 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EstudioDocOS3 update(EstudioDocOS3 ab0444s00) {
		return this.ab0444s00Dao.update(ab0444s00);
	}

	/**
	 * Finds a single row in the Ab0444s00 table.
	 * 
	 *  ab0444s00
	 *            Ab0444s00
	 *  Ab0444s00
	 *
	 * @param ab0444s00 the ab 0444 s 00
	 * @return the estudio doc OS 3
	 */
	public EstudioDocOS3 find(EstudioDocOS3 ab0444s00) {
		return (EstudioDocOS3) this.ab0444s00Dao.find(ab0444s00);
	}

	/**
	 * Deletes a single row in the Ab0444s00 table.
	 * 
	 *  ab0444s00
	 *            Ab0444s00
	 *
	 * @param ab0444s00 the ab 0444 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EstudioDocOS3 ab0444s00) {
		this.ab0444s00Dao.remove(ab0444s00);
	}

	/**
	 * Finds a list of rows in the Ab0444s00 table.
	 * 
	 *  ab0444s00
	 *            Ab0444s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0444s00>
	 *
	 * @param ab0444s00 the ab 0444 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<EstudioDocOS3> findAll(EstudioDocOS3 ab0444s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<EstudioDocOS3>) this.ab0444s00Dao.findAll(ab0444s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0444s00 table using like.
	 * 
	 *  ab0444s00
	 *            Ab0444s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0444s00>
	 *
	 * @param ab0444s00 the ab 0444 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<EstudioDocOS3> findAllLike(EstudioDocOS3 ab0444s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<EstudioDocOS3>) this.ab0444s00Dao.findAllLike(ab0444s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0444s00 table.
	 * 
	 *  filterAb0444s00
	 *            Ab0444s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0444s00>
	 *
	 * @param filterAb0444s00 the filter ab 0444 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<EstudioDocOS3> filter(
			EstudioDocOS3 filterAb0444s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<EstudioDocOS3> listaAb0444s00 = this.ab0444s00Dao
				.findAllLike(filterAb0444s00, jqGridRequestDto, false);
		Long recordNum = this.ab0444s00Dao.findAllLikeCount(
				filterAb0444s00 != null ? filterAb0444s00 : new EstudioDocOS3(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<EstudioDocOS3>> reorderSelection = this.ab0444s00Dao
					.reorderSelection(filterAb0444s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<EstudioDocOS3>(jqGridRequestDto,
					recordNum, listaAb0444s00, reorderSelection);
		}
		return new JQGridResponseDto<EstudioDocOS3>(jqGridRequestDto, recordNum,
				listaAb0444s00);
	}

	/**
	 * Searches rows in the Ab0444s00 table.
	 * 
	 *  filterAb0444s00
	 *            Ab0444s00
	 *  searchAb0444s00
	 *            Ab0444s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0444s00>>
	 *
	 * @param filterAb0444s00 the filter ab 0444 s 00
	 * @param searchAb0444s00 the search ab 0444 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<EstudioDocOS3>> search(
			EstudioDocOS3 filterAb0444s00, EstudioDocOS3 searchAb0444s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0444s00Dao.search(filterAb0444s00, searchAb0444s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0444s00 table.
	 * 
	 *  filterAb0444s00
	 *            Ab0444s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0444s00 the filter ab 0444 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(EstudioDocOS3 filterAb0444s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0444s00Dao.reorderSelection(filterAb0444s00,
				jqGridRequestDto, startsWith);
	}

}
